--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNsignalParams ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCobj
  local LOCsignPath    = ""
  local LOCundoState   = on
  local LOCaspectRatio = 1.0
  local LOCspinStartValue
  local LOCsignsArray = #()
  local LOCiniArraysUpdateRequired = true
  local LOCresourceKitMode   = 1

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNvspSignalFilter     FUNobj = (classof FUNobj.baseObject == VSP_Signal)

  fn DYNFUNsignalParams FUNobj =
  (
    FUNobj.baseObject.height             = FUNobj.baseObject.height
    DYNsignalParams.LOCobj               = FUNobj
    DYNsignalParams.SPDYNlength.value    = FUNobj.baseObject.width
    DYNsignalParams.SPDYNwidth.value     = FUNobj.baseObject.height
    if classOf FUNobj.baseObject == VSP_Signal then
    (
      DYNsignalParams.SPDYNnumPhases.enabled = true
      DYNsignalParams.SPDYNcurPhase.enabled  = true
      DYNsignalParams.SPDYNheight.enabled    = true
      DYNsignalParams.SPDYNdepth.enabled     = true
      DYNsignalParams.SPDYNposts.enabled     = true
      DYNsignalParams.SPDYNedgeOff.enabled   = true

      DYNsignalParams.SPDYNnumPhases.value   = FUNobj.numphases
      DYNsignalParams.SPDYNcurPhase.range    = [1,FUNobj.numphases,FUNobj.curPhase]
      DYNsignalParams.SPDYNheight.value      = FUNobj.baseObject.pheight
      DYNsignalParams.SPDYNdepth.value       = FUNobj.baseObject.depth
      DYNsignalParams.SPDYNposts.value       = FUNobj.baseObject.posts
      DYNsignalParams.SPDYNedgeOff.value     = FUNobj.baseObject.edgeOff
      DYNsignalParams.SPDYNedgeOff.range.y   = FUNobj.baseObject.width / 4
    )
    else
    (
      DYNsignalParams.SPDYNnumPhases.enabled = false
      DYNsignalParams.SPDYNcurPhase.enabled  = false
      DYNsignalParams.SPDYNheight.enabled    = false
      DYNsignalParams.SPDYNdepth.enabled     = false
      DYNsignalParams.SPDYNposts.enabled     = false
      DYNsignalParams.SPDYNedgeOff.enabled   = false
    )
    --- Get current SignFace
    DYNsignalParams.LOCsignsArray = DYNFUNgetMatChannelNames FUNobj.material false false DYNINImatIDlimit
    if DYNsignalParams.LOCsignsArray.count >= 10 then (for i = 1 to 10 do deleteItem DYNsignalParams.LOCsignsArray 1)
    if DYNsignalParams.LOCsignsArray.count > 0 then
    (
      local LOCmatID = if (FUNobj.baseObject.type - 10) > DYNsignalParams.LOCsignsArray.count then DYNsignalParams.LOCsignsArray.count else (FUNobj.baseObject.type - 10)
      FUNobj.baseObject.type = LOCmatID + 10
      if DYNsignalParams.LOCsignsArray.count >= (FUNobj.baseObject.type - 10) then
      (
        DYNsignalParams.LBDYNobjName.text  = DYNsignalParams.LOCsignsArray[FUNobj.baseObject.type - 10]
      )
      else
      (
        DYNsignalParams.LBDYNobjName.text  = ""
      )

      DYNsignalParams.BMDYNbitmap.bitmap = DYNFUNrenderMatMap 160 120 FUNobj.material FUNobj.baseObject.type

      --- If Signal Object INI File Definition does not exist, disable RESET and DROPDOWN list (This can occur when the wrong country kit is currently loaded)
      local LOCswitch = doesFileExist (DYNsignalParams.LOCsignPath + DYNsignalParams.LBDYNobjName.text + ".ini")
      DYNsignalParams.BUDYNreset.enabled   = LOCswitch
    )
    else
    (
      DYNsignalParams.BUDYNreset.enabled   = false
    )

    --- Create A Temporary Array Of Signal Object INI Files From Current DVSP Country Kit Folders
    local LOCsignArray = DYNFUNgetfiles DYNsignalParams.LOCsignPath 1 "*.ini"
    DYNsignalParams.BUDYNotherTypes.enabled = if classOf FUNobj.material == Multimaterial and LOCsignArray.count > 0 then true else false

    --- Check whether other instances exist
    DYNFUNgatherInstancesOfNode DYNsignalParams FUNobj

    --- Store current aspect ratio of sign
    DYNsignalParams.LOCaspectRatio = DYNsignalParams.SPDYNlength.value / DYNsignalParams.SPDYNwidth.value
  )


  ---SECTION 3 - DEFINE PANEL LAYOUT---
  groupbox GBDYN01 width:(DYNiniExplorerWidth - 21) height:193 pos:[4,7]
  bitmap BMDYNbitmap     width:(DYNiniExplorerWidth - 39) pos:[13,26] height:120
  label LBDYNobjName     width:(DYNiniExplorerWidth - 108) pos:[13,155]
  button BUDYNotherTypes width:(DYNiniExplorerWidth - 39) pos:[13,173]

  groupbox GBDYN02 width:(DYNiniExplorerWidth - 21) height:62 pos:[4,205]
  label   LBDYNnumPhases pos:[13,224] width:(DYNiniExplorerWidth - 108)
  label   LBDYNcurPhase  pos:[13,245] width:(DYNiniExplorerWidth - 108)
  spinner SPDYNnumPhases "" fieldwidth:60 range:[1,24,3] type:#integer pos:[(DYNiniExplorerWidth - 96),224]
  spinner SPDYNcurPhase  "" fieldwidth:60 range:[1,24,1] type:#integer pos:[(DYNiniExplorerWidth - 96),245]

  groupbox GBDYN03 width:(DYNiniExplorerWidth - 21) height:88 pos:[4,272]
  label   LBDYNlength pos:[13,291] width:(DYNiniExplorerWidth - 108)
  label   LBDYNwidth  pos:[13,312] width:(DYNiniExplorerWidth - 108)
  spinner SPDYNlength "" fieldwidth:44 range:[0.05,10000,1.0] type:#worldunits pos:[(DYNiniExplorerWidth - 96),291]
  spinner SPDYNwidth  "" fieldwidth:44 range:[0.05,10000,1.0] type:#worldunits pos:[(DYNiniExplorerWidth - 96),312]
  button  BUDYNreset  width:(DYNiniExplorerWidth - 37) pos:[13,333]
  checkbutton CBDYNlock width:16 height:18 pos:[(DYNINIexplorerWidth - 39),302] iconName:"Common/Lock" iconSize:[16,16] checked:true highlightColor:DYNINIhighlightColor

  groupbox GBDYN04 width:(DYNiniExplorerWidth - 21) height:104 pos:[4,365]
  label LBDYNheight  pos:[13,384] width:(DYNiniExplorerWidth - 108)
  label LBDYNdepth   pos:[13,405] width:(DYNiniExplorerWidth - 108)
  label LBDYNposts   pos:[13,426] width:(DYNiniExplorerWidth - 108)
  label LBDYNedgeoff pos:[13,447] width:(DYNiniExplorerWidth - 108)
  spinner SPDYNheight  "" fieldwidth:60 range:[0.1,10000,5.0] type:#worldunits pos:[(DYNiniExplorerWidth - 96),384]
  spinner SPDYNdepth   "" fieldwidth:60 range:[-10000,0,-1.0] type:#worldunits pos:[(DYNiniExplorerWidth - 96),405]
  spinner SPDYNposts   "" fieldwidth:60 range:[0,5,2]         type:#integer    pos:[(DYNiniExplorerWidth - 96),426]
  spinner SPDYNedgeoff "" fieldwidth:60 range:[0,10000.0,0.1] type:#worldunits pos:[(DYNiniExplorerWidth - 96),447]

  groupbox GBDYN05 width:(DYNiniExplorerWidth - 21) height:72  pos:[4,474]
  checkbutton CBDYNlinked width:(DYNiniExplorerWidth - 39) highlightColor:DYNINIhighlightColor pos:[13,493]
  pickbutton PKDYNlink    width:(DYNiniExplorerWidth - 39) highlightColor:DYNINIhighlightColor filter:DYNFUNvspSignalFilter pos:[13,519]

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNsignalParams open do
  (
    DYNsignalParams.title = DYNuiRolloutNames[20]
    GBDYN01.text          = DYNuiResourcesGroups[60]
    GBDYN02.text          = DYNuiResourcesGroups[61]
    GBDYN03.text          = DYNuiResourcesGroups[62]
    GBDYN04.text          = DYNuiResourcesGroups[59]
    GBDYN05.text          = DYNuiResourcesGroups[1]
    LBDYNnumPhases.text   = DYNuiResourcesLabels[198]
    LBDYNcurPhase.text    = DYNuiResourcesLabels[199]
    LBDYNlength.text      = DYNuiResourcesLabels[29]
    LBDYNwidth.text       = DYNuiResourcesLabels[30]
    LBDYNheight.text      = DYNuiResourcesLabels[200]
    LBDYNdepth.text       = DYNuiResourcesLabels[201]
    LBDYNposts.text       = DYNuiResourcesLabels[202]
    LBDYNedgeoff.text     = DYNuiResourcesLabels[203]
    BUDYNreset.text       = DYNuiResourcesButtons[13]
    LOCsignPath           = DYNcountryPath + DYNfolderNameObjLibs + "\\" + DYNfolderNameSigns + "\\"
    BUDYNotherTypes.text  = DYNuiResourcesButtons[58]
    PKDYNlink.text        = DYNuiResourcesButtons[24]
    LOCiniArraysUpdateRequired = true
  )

  on DYNsignalParams close do
  (
    LOCobj = undefined
    LOCsignsArray = #()
  )

  on BUDYNreset pressed do
  (
    local LOCsizeArray = DYNFUNobjectINIparams LBDYNobjName.text 4 LOCresourceKitMode
    SPDYNlength.value = LOCobj.baseObject.width   = LOCsizeArray[3]
    SPDYNwidth.value  = LOCobj.baseObject.height  = LOCsizeArray[4]
    LOCaspectRatio     = SPDYNlength.value / SPDYNwidth.value
  )

  --- Length Spinner Controls
  on SPDYNlength changed arg do
  (
    LOCobj.baseObject.width = arg
    SPDYNedgeoff.range.y = arg/4
    if SPDYNedgeoff.value > (arg/4) then SPDYNedgeoff.value = (arg/4)

    if CBDYNlock.checked then
    (
      LOCobj.baseObject.height = arg / LOCaspectRatio
      SPDYNwidth.value = LOCobj.baseObject.height
    )
    else
    (
      LOCaspectRatio = SPDYNlength.value / SPDYNwidth.value
    )
  )

  --- Width Spinner Controls
  on SPDYNwidth changed arg do
  (
    LOCobj.baseObject.height = arg

    if CBDYNlock.checked then
    (
      LOCobj.baseObject.width = arg * LOCaspectRatio
      SPDYNlength.value = LOCobj.baseObject.width
      SPDYNedgeoff.range.y = LOCobj.baseObject.width/4
      if SPDYNedgeoff.value > (LOCobj.baseObject.width/4) then SPDYNedgeoff.value = (LOCobj.baseObject.width/4)
    )
    else
    (
      LOCaspectRatio = SPDYNlength.value / SPDYNwidth.value
    )
  )

  --- Phases Spinner Controls
  on SPDYNnumPhases changed arg do
  (
    with undo label:(DYNuiResourcesUndoLabels[13]) LOCundoState LOCobj.baseObject.numPhases = arg
    SPDYNcurPhase.range.y = arg
    if LOCobj.baseObject.curPhase > arg then
    (
      LOCobj.baseObject.curPhase = arg
      SPDYNcurPhase.value = arg
    )
  )
  on SPDYNnumPhases buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNnumPhases.value)
  on SPDYNnumPhases buttonUp    do
  (
    if LOCspinStartValue != SPDYNnumPhases.value then
    (
      with undo off LOCobj.baseObject.numPhases = LOCspinStartValue
      with undo label:(DYNuiResourcesUndoLabels[13]) on LOCobj.baseObject.numPhases = SPDYNnumPhases.value
    )
    LOCundoState    = on
  )

  --- Phase Spinner Controls
  on SPDYNcurPhase changed arg do (with undo label:(DYNuiResourcesUndoLabels[13]) LOCundoState LOCobj.baseObject.curPhase = arg)
  on SPDYNcurPhase buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNcurPhase.value)
  on SPDYNcurPhase buttonUp    do
  (
    if LOCspinStartValue != SPDYNcurPhase.value then
    (
      with undo off LOCobj.baseObject.curPhase = LOCspinStartValue
      with undo label:(DYNuiResourcesUndoLabels[13]) on LOCobj.baseObject.curPhase = SPDYNcurPhase.value
    )
    LOCundoState    = on
  )

  --- Height Spinner Controls
  on SPDYNheight changed arg do (with undo label:(DYNuiResourcesUndoLabels[13]) LOCundoState LOCobj.baseObject.pHeight = arg)
  on SPDYNheight buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNheight.value)
  on SPDYNheight buttonUp    do
  (
    if LOCspinStartValue != SPDYNheight.value then
    (
      with undo off LOCobj.baseObject.pHeight = LOCspinStartValue
      with undo label:(DYNuiResourcesUndoLabels[13]) on LOCobj.baseObject.pHeight = SPDYNheight.value
    )
    LOCundoState    = on
  )

  --- Depth Spinner Controls
  on SPDYNdepth changed arg do (with undo label:(DYNuiResourcesUndoLabels[13]) LOCundoState LOCobj.baseObject.depth = arg)
  on SPDYNdepth buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNdepth.value)
  on SPDYNdepth buttonUp    do
  (
    if LOCspinStartValue != SPDYNdepth.value then
    (
      with undo off LOCobj.baseObject.depth = LOCspinStartValue
      with undo label:(DYNuiResourcesUndoLabels[13]) on LOCobj.baseObject.depth = SPDYNdepth.value
    )
    LOCundoState    = on
  )

  --- Posts Spinner Controls
  on SPDYNposts changed arg do (with undo label:(DYNuiResourcesUndoLabels[13]) LOCundoState LOCobj.baseObject.posts = arg)
  on SPDYNposts buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNposts.value)
  on SPDYNposts buttonUp    do
  (
    if LOCspinStartValue != SPDYNposts.value then
    (
      with undo off LOCobj.baseObject.posts = LOCspinStartValue
      with undo label:(DYNuiResourcesUndoLabels[13]) on LOCobj.baseObject.posts = SPDYNposts.value
    )
    LOCundoState    = on
  )

  --- Edge Offset Spinner Controls
  on SPDYNedgeOff changed arg do (with undo label:(DYNuiResourcesUndoLabels[13]) LOCundoState LOCobj.baseObject.edgeOff = arg)
  on SPDYNedgeOff buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNedgeOff.value)
  on SPDYNedgeOff buttonUp    do
  (
    if LOCspinStartValue != SPDYNedgeOff.value then
    (
      with undo off LOCobj.baseObject.edgeOff = LOCspinStartValue
      with undo label:(DYNuiResourcesUndoLabels[13]) on LOCobj.baseObject.edgeOff = SPDYNedgeOff.value
    )
    LOCundoState    = on
  )

  on BUDYNotherTypes pressed do
  (
    --- Update Main Object INI File AX Internal Arrays
    if LOCiniArraysUpdateRequired then
    (
      DYNobjectPlacer.DYNFUNmakeINIobjFileArrays()
      LOCiniArraysUpdateRequired = false
    )

    --- Display Tree Selection List
    local LOCnewFile = DYNFUNdisplayListBoxWithMapPreview DYNsignalParams DYNuiResourcesTitlebars[19] "" 4 1 "Sign Defaults" "Style" "3"

    if LOCnewFile != "" then
    (
      if (findItem LOCsignsArray LOCnewFile) == 0 then
      (
        --- Update Current Tree Object With New Tree INI Definition
        local LOCsizeArray = DYNFUNobjectINIparams LOCnewFile 4 LOCresourceKitMode
        local LOCmatID = DYNFUNaddSignMatChannel LOCobj.material LOCsizeArray false
        LOCobj.baseObject.type = LOCmatID + 10
        SPDYNlength.value  = LOCobj.baseObject.width   = LOCsizeArray[3]
        SPDYNwidth.value   = LOCobj.baseObject.height  = LOCsizeArray[4]
        if (classof LOCobj.baseObject) == VSP_Signal then
        (
          SPDYNheight.value  = LOCobj.baseObject.pheight = LOCsizeArray[4] + LOCsizeArray[6]
          SPDYNposts.value   = LOCobj.baseObject.posts   = LOCsizeArray[5]
          SPDYNedgeoff.range.y = SPDYNlength.value/4
          if SPDYNedgeoff.value > (SPDYNlength.value/4) then SPDYNedgeoff.value = (SPDYNlength.value/4)
        )
        setAppData LOCobj 423 (LOCobj.baseObject.type as string)
        setAppData LOCobj 424 (LOCsignPath + LOCnewFile + ".ini")
        DYNFUNsignalParams LOCobj
        DYNproperties.DYNFUNupdPropertiesPanel()
      )
      else
      (
        undo off
        (
          local LOCnewMatID = findItem LOCsignsArray LOCnewFile
          if LOCobj.baseObject.type != LOCnewMatID then
          (
            LOCobj.baseObject.type = LOCnewMatID + 10

            local LOCsizeArray = DYNFUNobjectINIparams LOCnewFile 4 LOCresourceKitMode
            SPDYNlength.value  = LOCobj.baseObject.width   = LOCsizeArray[3]
            SPDYNwidth.value   = LOCobj.baseObject.height  = LOCsizeArray[4]
            LOCaspectRatio     = SPDYNlength.value / SPDYNwidth.value
            if (classof LOCobj.baseObject) == VSP_Signal then
            (
              SPDYNheight.value  = LOCobj.baseObject.pheight = LOCsizeArray[4] + LOCsizeArray[6]
              SPDYNposts.value   = LOCobj.baseObject.posts   = LOCsizeArray[5]
              SPDYNedgeoff.range.y = SPDYNlength.value/4
              if SPDYNedgeoff.value > (SPDYNlength.value/4) then SPDYNedgeoff.value = (SPDYNlength.value/4)
            )
            setAppData LOCobj 423 (LOCobj.baseObject.type as string)
            setAppData LOCobj 424 (LOCsignPath + LOCnewFile + ".ini")
            DYNFUNsignalParams LOCobj
            DYNproperties.DYNFUNupdPropertiesPanel()
          )
        )
      )
    )
  )

  on CBDYNlinked changed arg do
  (
    if arg == false then
    (
      LOCobj = DYNFUNunlinkNodeInstance DYNsignalParams LOCobj 4 false
      select LOCobj
    )
  )

  on PKDYNlink picked arg do
  (
    if arg != LOCobj then
    (
      LOCobj = DYNFUNunlinkNodeInstance DYNsignalParams LOCobj 4 true
      instanceReplace LOCobj arg
      select LOCobj
    )
  )

)
